﻿using gov.va.med.vbecs.Common;
using System;

namespace gov.va.med.vbecs.BOL
{
    /// <summary>
    /// Blood Unit Model
    /// </summary>
    public class BloodUnitModel : IEquatable<BloodUnitModel>
    {
        /// <summary>
        /// BloodUnitGuid
        /// </summary>
        public Guid BloodUnitGuid { get; private set; }
        /// <summary>
        /// BloodUnitStatusGuid
        /// </summary>
        public Guid BloodUnitStatusGuid { get; private set; }
        /// <summary>
        /// UnitProductCode
        /// </summary>
        public string UnitProductCode { get; set; }
        /// <summary>
        /// DonationTypeCode
        /// </summary>
        public string DonationTypeCode { get; set; }
        /// <summary>
        /// UnitDivisionId
        /// </summary>
        public string UnitDivisionId { get; set; }
        /// <summary>
        /// ProductCode (UnitProductCode + DonationTypeCode + UnitDivisionId)
        /// </summary>
        public string ProductCode
        {
            get
            {
                if (LabelTypeCode == "C")
                {
                    // If Codabar only display the UnitProductCode
                    return (UnitProductCode ?? "");
                }
                else
                {
                    return (UnitProductCode ?? "") + (DonationTypeCode ?? "") + (UnitDivisionId ?? "");
                }
            }
        }
        /// <summary>
        /// ProductShortName
        /// </summary>
        public string ProductShortName { get; private set; }
        /// <summary>
        /// AboRh
        /// </summary>
        public string AboRh
        {
            get
            {
                return UnitAbo + " " + UnitRh;
            }
        }
        /// <summary>
        /// UnitAbo
        /// </summary>
        public string UnitAbo { get; set; }
        /// <summary>
        /// UnitRh
        /// </summary>
        public string UnitRh { get; set; }
        /// <summary>
        /// BloodUnitStatusRowVersion
        /// </summary>
        public byte[] BloodUnitStatusRowVersion { get; set; }
        /// <summary>
        /// UnitStatusCode
        /// </summary>
        public UnitStatusCode UnitStatusCode { get; set; }
        /// <summary>
        /// LabelTypeCode
        /// </summary>
        public string LabelTypeCode { get; set; }

        /// <summary>
        /// Constructor
        /// </summary>
        /// <param name="bloodUnitGuid"></param>
        /// <param name="bloodUnitStatusGuid">for locking</param>
        /// <param name="unitProductCode"></param>
        /// <param name="donationTypeCode"></param>
        /// <param name="unitDivisionId"></param>
        /// <param name="productShortName"></param>
        /// <param name="unitAbo"></param>
        /// <param name="unitRh"></param>
        /// <param name="unitStatusCode"></param>
        /// <param name="labelTypeCode"></param>
        /// <param name="bloodUnitStatusRowVersion"></param>
        public BloodUnitModel(
            Guid bloodUnitGuid,
            Guid bloodUnitStatusGuid,
            string unitProductCode,
            string donationTypeCode,
            string unitDivisionId,
            string productShortName,
            string unitAbo,
            string unitRh,
            UnitStatusCode unitStatusCode,
            string labelTypeCode,
            byte[] bloodUnitStatusRowVersion)
        {
            BloodUnitGuid = bloodUnitGuid;
            BloodUnitStatusGuid = bloodUnitStatusGuid;
            UnitProductCode = unitProductCode;
            DonationTypeCode = donationTypeCode;
            UnitDivisionId = unitDivisionId;
            ProductShortName = productShortName;
            UnitAbo = unitAbo;
            UnitRh = unitRh;
            UnitStatusCode = unitStatusCode;
            LabelTypeCode = labelTypeCode;
            BloodUnitStatusRowVersion = bloodUnitStatusRowVersion;
        }

        /// <summary>
        /// Clone ProductCode object
        /// </summary>
        /// <returns></returns>
        public BloodUnitModel Clone()
        {
            return new BloodUnitModel(BloodUnitGuid, BloodUnitStatusGuid, UnitProductCode, DonationTypeCode, UnitDivisionId, ProductShortName, UnitAbo, UnitRh, UnitStatusCode, LabelTypeCode, BloodUnitStatusRowVersion);
        }

        /// <summary>
        /// Equals
        /// </summary>
        /// <param name="other"></param>
        /// <returns></returns>
        public bool Equals(BloodUnitModel other)
        {
            if (ReferenceEquals(null, other)) return false;
            if (ReferenceEquals(this, other)) return true;
            return UnitStatusCode == other.UnitStatusCode &&
                Equals(BloodUnitStatusRowVersion, other.BloodUnitStatusRowVersion) &&
                string.Equals(UnitRh, other.UnitRh) &&
                string.Equals(UnitAbo, other.UnitAbo) &&
                string.Equals(ProductShortName, other.ProductShortName) &&
                string.Equals(UnitDivisionId, other.UnitDivisionId) &&
                string.Equals(DonationTypeCode, other.DonationTypeCode) &&
                string.Equals(UnitProductCode, other.UnitProductCode) &&
                BloodUnitGuid.Equals(other.BloodUnitGuid);
        }

        /// <summary>
        /// Equals
        /// </summary>
        /// <param name="obj"></param>
        /// <returns></returns>
        public override bool Equals(object obj)
        {
            if (ReferenceEquals(null, obj)) return false;
            if (ReferenceEquals(this, obj)) return true;
            if (obj.GetType() != this.GetType()) return false;
            return Equals((BloodUnitModel)obj);
        }

        /// <summary>
        /// GetHashcode
        /// </summary>
        /// <returns></returns>
        public override int GetHashCode()
        {
            unchecked
            {
                int hashCode = (int)UnitStatusCode;
                hashCode = (hashCode * 397) ^ (BloodUnitStatusRowVersion != null ? BloodUnitStatusRowVersion.GetHashCode() : 0);
                hashCode = (hashCode * 397) ^ (UnitRh != null ? UnitRh.GetHashCode() : 0);
                hashCode = (hashCode * 397) ^ (UnitAbo != null ? UnitAbo.GetHashCode() : 0);
                hashCode = (hashCode * 397) ^ (ProductShortName != null ? ProductShortName.GetHashCode() : 0);
                hashCode = (hashCode * 397) ^ (UnitDivisionId != null ? UnitDivisionId.GetHashCode() : 0);
                hashCode = (hashCode * 397) ^ (DonationTypeCode != null ? DonationTypeCode.GetHashCode() : 0);
                hashCode = (hashCode * 397) ^ (UnitProductCode != null ? UnitProductCode.GetHashCode() : 0);
                hashCode = (hashCode * 397) ^ BloodUnitGuid.GetHashCode();
                return hashCode;
            }
        }
    }
}
